varying vec2 f_texcoord_foam, f_texcoord_effect;

varying float f_mainSpecularFactor;
varying float f_pos_factor;

varying float f_factor_alpha;
uniform float wave_phase;
uniform vec3 water_color;

#ifdef MULTI_TEX
uniform sampler2D texture_foam;
varying float f_factor_foam;
#endif

uniform sampler2D tex_border;
uniform sampler2D tex_effect;
varying float f_effect_factor;

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
#endif



void main(void)
{
	if(f_factor_alpha == 0.0)
		discard;

	vec4 colorResult = vec4(water_color, 1.0);

	//Border
	const float fac3Peak = 0.3;
	float lightBorderIntensity;
	if(f_factor_alpha < fac3Peak)
		lightBorderIntensity = f_factor_alpha/fac3Peak;
	else
	{
		lightBorderIntensity = 1.0 - ((f_factor_alpha-fac3Peak)/(1.0-fac3Peak));
		lightBorderIntensity *= lightBorderIntensity;
	}

	const float texBorderScale = 1.5;
	const float texBorderScalePeriod = 0.02;
	vec4 colorTexBorder = texture2D(tex_border, f_texcoord_foam*texBorderScale + vec2(f_effect_factor*texBorderScalePeriod));
	float lightBorderFactor = (colorTexBorder.r*f_mainSpecularFactor*currentLight.ambient.r + colorTexBorder.g*f_effect_factor) * lightBorderIntensity;


#ifdef MULTI_TEX
	vec4 colorTex2 = texture2D(texture_foam, f_texcoord_foam);
	colorResult = mix(colorResult, vec4(colorTex2.rgb, 1.0), f_factor_foam*colorTex2.a);
#endif

	colorResult.w = getWaterAlpha(f_factor_alpha);

#ifdef WATER_SHADER_ALPHA
	colorResult.w *= WATER_SHADER_ALPHA_VALUE;
#endif

	//Lighting
	const float highlightFactorMin = 0.05;
	const float highlightFactorRange = 0.3;
	vec4 colorTexHighlight = texture2D(tex_effect, f_texcoord_effect);
	float highlightFactorTex = mix(colorTexHighlight.r, colorTexHighlight.g, f_effect_factor);
	vec3 highlightFactor = vec3(highlightFactorMin + highlightFactorRange * highlightFactorTex);

	vec3 diffuseReflection = currentLight.diffuse * normalize(currentLight.position).y; //optimized getDiffuseReflection
	vec3 ambientLighting = getAmbientLighting(currentLight.ambient, currentMaterial.ambient);
	vec4 colorLight = vec4(f_pos_factor*highlightFactor*diffuseReflection + ambientLighting, 1.0);
	colorResult = colorLight * colorResult;

	//White Specular
	const float mainSpecularInfluence = 0.8;
	float mainSpecularReflection = f_mainSpecularFactor;
	float mainSpecularReflectionTex = colorTexHighlight.b;
	float whiteSpecular = mainSpecularInfluence*mainSpecularReflection*mainSpecularReflectionTex;

	whiteSpecular *= f_pos_factor;
	lightBorderFactor *= f_pos_factor;

	colorResult = mix(colorResult, vec4(currentLight.specular, colorResult.w), whiteSpecular);
	colorResult = mix(colorResult, vec4(currentLight.specular, max(colorResult.w, lightBorderFactor)), lightBorderFactor);

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR*FOG_COLOR_ADAPT, f_fogFactor);
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR_GROUND, f_fogFactorGround);
#endif

	gl_FragColor = colorResult;
}
